
;--------------------------------
;Include Modern UI

  !include "MUI.nsh"
  !include Library.nsh ; for lib uninstallation
;--------------------------------
;Configuration

  ;General
name "NOW Player v1.0"; Name of the installer
outfile "NOW Player v1.0 setup.exe" ; installer name

!define MUI_ICON "setup.ico"
!define MUI_UNICON "setup.ico"

  ;Default installation folder
installdir "$PROGRAMFILES\NOW Player"
  
  ;Get installation folder from registry if available
  InstallDirRegKey HKCU "Software\NOW Player" ""

CRCCheck on ; check the installer is damaged
XPStyle on ; add xp manifest to installer
RequestExecutionLevel admin ; execution level for Windows Vista and higher
BrandingText "NOW Player v1.0"
;--------------------------------
;Interface Settings
  !define MUI_WELCOMEFINISHPAGE_BITMAP "wizard.bmp"
  !define MUI_UNWELCOMEFINISHPAGE_BITMAP "wizard.bmp"
  !define MUI_ABORTWARNING

;--------------------------------
;Pages

  !insertmacro MUI_PAGE_WELCOME
  !insertmacro MUI_PAGE_LICENSE "License.txt"
  !insertmacro MUI_PAGE_INSTFILES
  !insertmacro MUI_PAGE_FINISH
  
  !insertmacro MUI_UNPAGE_WELCOME
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  !insertmacro MUI_UNPAGE_FINISH
  
;--------------------------------
;Languages
 
  !insertmacro MUI_LANGUAGE "English"

;--------------------------------
;Installer Sections

Section "Dummy Section" SecDummy

setoutpath $INSTDIR

file "License.txt"
file "bass.dll"
file "bass_wadsp.dll"
file "hifi-audio.dll"
file "NOW Player.exe"
file "plugin.ini"
file "tags.dll"
file "demo.mp3" 
 
 ;Store installation folder
 WriteRegStr HKCU "Software\NOW Player" "" $INSTDIR

 ; uninstall details
 WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\NOW Player" "DisplayName" "NOW Player 1.0" 
 WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\NOW Player" "UninstallString" "$INSTDIR\Uninstall.exe" 
 WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\NOW Player" "Publisher" "Ruchira Hasaranga" 
 WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\NOW Player" "DisplayVersion" "1.0" 
 WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\NOW Player" "HelpLink" "ruchira66@gmail.com" 

 ; associate with mp3 files
 WriteRegStr HKCR "NOWPlayer.File.MP3" "" "MP3 File"
 WriteRegStr HKCR "NOWPlayer.File.MP3\DefaultIcon" "" "$INSTDIR\NOW Player.exe,0"
 WriteRegStr HKCR "NOWPlayer.File.MP3\shell" "" "Play"
 WriteRegStr HKCR "NOWPlayer.File.MP3\shell\open" "" ""
 WriteRegStr HKCR "NOWPlayer.File.MP3\shell\open\command" "" '$INSTDIR\NOW Player.exe "%1"'
 WriteRegStr HKCR "NOWPlayer.File.MP3\shell\play" "" ""
 WriteRegStr HKCR "NOWPlayer.File.MP3\shell\play\command" "" '$INSTDIR\NOW Player.exe "%1"'

 ; associate with mp3 files
 ReadRegStr $0 HKLM "SOFTWARE\Classes\.mp3" ""
 StrCmp $0 "NOWPlayer.File.MP3" +2 0
 WriteRegStr HKLM "SOFTWARE\Classes\.mp3" "NOWPlayer_Back" $0
 WriteRegStr HKLM "SOFTWARE\Classes\.mp3" "" "NOWPlayer.File.MP3"

 ; associate with mp3 files
 ReadRegStr $0 HKCU "SOFTWARE\Classes\.mp3" ""
 StrCmp $0 "NOWPlayer.File.MP3" +2 0
 WriteRegStr HKCU "SOFTWARE\Classes\.mp3" "NOWPlayer_Back" $0
 WriteRegStr HKCU "SOFTWARE\Classes\.mp3" "" "NOWPlayer.File.MP3"

 CreateDirectory "$SMPROGRAMS\NOW Player"
 CreateShortCut "$SMPROGRAMS\NOW Player\NOW Player.lnk" "$INSTDIR\NOW Player.exe"
 CreateShortCut "$SMPROGRAMS\NOW Player\Uninstall NOW Player.lnk" "$INSTDIR\Uninstall.exe"
 CreateShortCut "$DESKTOP\NOW Player.lnk" "$INSTDIR\NOW Player.exe"


  ;Create uninstaller
  WriteUninstaller "$INSTDIR\Uninstall.exe"

 Call RefreshShellIcons 

SectionEnd


;Uninstaller Section

Section "Uninstall"

RMDir /r $INSTDIR
RMDir /r "$SMPROGRAMS\NOW Player"
Delete "$DESKTOP\NOW Player.lnk"

DeleteRegKey /ifempty HKCU "Software\NOW Player"

DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\NOW Player"

 ; remove mp3 association
 ReadRegStr $0 HKLM "SOFTWARE\Classes\.mp3" ""
 StrCmp $0 "NOWPlayer.File.MP3" 0 +3
 ReadRegStr $0 HKLM "SOFTWARE\Classes\.mp3" "NOWPlayer_Back"
 WriteRegStr HKLM "SOFTWARE\Classes\.mp3" "" $0
 DeleteRegValue HKLM "SOFTWARE\Classes\.mp3" "NOWPlayer_Back"

 ; remove mp3 association
 ReadRegStr $0 HKCU "SOFTWARE\Classes\.mp3" ""
 StrCmp $0 "NOWPlayer.File.MP3" 0 +3
 ReadRegStr $0 HKCU "SOFTWARE\Classes\.mp3" "NOWPlayer_Back"
 WriteRegStr HKCU "SOFTWARE\Classes\.mp3" "" $0
 DeleteRegValue HKCU "SOFTWARE\Classes\.mp3" "NOWPlayer_Back"

 DeleteRegKey HKCR "NOWPlayer.File.MP3"

 Call un.RefreshShellIcons

SectionEnd  


Function .onInstSuccess

ShellExecAsUser::ShellExecAsUser "open" "$INSTDIR\NOW Player.exe" -firsttime

FunctionEnd

Function RefreshShellIcons
  ; By jerome tremblay - april 2003
  System::Call 'shell32.dll::SHChangeNotify(i, i, i, i) v \
  (${SHCNE_ASSOCCHANGED}, ${SHCNF_IDLIST}, 0, 0)'
FunctionEnd

Function un.RefreshShellIcons
  ; By jerome tremblay - april 2003
  System::Call 'shell32.dll::SHChangeNotify(i, i, i, i) v \
  (${SHCNE_ASSOCCHANGED}, ${SHCNF_IDLIST}, 0, 0)'
FunctionEnd


